﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class RegistrantStatusMapperTests
    {
        string con = "Data Source=DNS;Initial Catalog=Registry_AHOBPRHRE;Integrated Security=True;Encrypt=yes;TrustServerCertificate=True";
        [TestMethod]
        public void GetServiceStatusReturnsFourWhenGivenAnEmptyEdipi()
        {
            var edipi = "";
            var cut = new RegistrantServiceStatusMapper();
            var actual = cut.GetServiceStatus(edipi);
            Assert.AreEqual(4, actual);
        }
        //[TestMethod]
        //public void GetServiceStatusCorrectServiceStatusWhenGivenProperEdipi()
        //{
        //    var edipi = "1006753503";
        //    var cut = new RegistrantServiceStatusMapper(con);
        //    var actual = cut.GetServiceStatus(edipi);
        //    Assert.AreEqual(5, actual);
        //}

        [TestMethod]
        public void GetDataWhenGivenProperEdipi()
        {
            var edipi = "1006753503";
            var cut = new RegistrantServiceStatusMapper();
            var actual = cut.GetData(edipi);
            Assert.AreEqual(edipi, actual.edipi);
        }
    }
}
